/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.uddi.api_v2.uddi_org;

import filenet.ws.listener.uddi.api_v2.uddi_org.AccessPoint;
import filenet.ws.listener.uddi.api_v2.uddi_org.BindingKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.Description;
import filenet.ws.listener.uddi.api_v2.uddi_org.HostingRedirector;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModel;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelInstanceDetails;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelInstanceInfo;
import filenet.ws.listener.uddi.api_v2.uddi_org.URLType;
import filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSWorkflowServiceInfo;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.axis.description.AttributeDesc;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.w3c.dom.Element;

public class BindingTemplate
implements Serializable {
    private static final long serialVersionUID = 464L;
    protected Element baseElement = null;
    private Description[] description = null;
    private AccessPoint accessPoint = null;
    private HostingRedirector hostingRedirector = null;
    private TModelInstanceDetails tModelInstanceDetails = null;
    private ServiceKey serviceKey = null;
    private BindingKey bindingKey = null;
    private static HostingRedirector dummyHostingRedirector = null;
    private Object __equalsCalc = null;
    private boolean __hashCodeCalc = false;
    private static TypeDesc typeDesc;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Nov 2005 14:17:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public static String genBindingKeyString(WSWorkflowServiceInfo serviceInfo) {
        if (serviceInfo.getVersionAgnostic()) {
            return "bk:" + serviceInfo.getIsolatedRegion() + ":" + serviceInfo.getName() + ":" + serviceInfo.getWorkspaceId();
        }
        return "bk:" + serviceInfo.getIsolatedRegion() + ":" + serviceInfo.getName();
    }

    public static String genBindingName(WSWorkflowServiceInfo serviceInfo) {
        return serviceInfo.getName().trim();
    }

    public static String genBindingDescription(WSWorkflowServiceInfo serviceInfo) {
        String descrip = serviceInfo.getDescription();
        if (descrip != null && (descrip = descrip.trim()).length() == 0) {
            descrip = BindingTemplate.genBindingName(serviceInfo);
        }
        return descrip;
    }

    public BindingTemplate() {
    }

    public BindingTemplate(WSWorkflowServiceInfo serviceInfo, TModel tm, ServiceKey sk) {
        this.serviceKey = sk;
        this.bindingKey = new BindingKey(BindingTemplate.genBindingKeyString(serviceInfo));
        this.hostingRedirector = dummyHostingRedirector;
        this.description = new Description[1];
        this.description[0] = new Description(BindingTemplate.genBindingDescription(serviceInfo));
        this.accessPoint = new AccessPoint();
        this.accessPoint.setURLType(URLType.http);
        if (tm != null && tm.getOverviewDoc() != null) {
            this.accessPoint.setValue(tm.getOverviewDoc().getOverviewURL());
        }
        this.tModelInstanceDetails = new TModelInstanceDetails();
        TModelInstanceInfo[] info = new TModelInstanceInfo[]{new TModelInstanceInfo(tm)};
        this.tModelInstanceDetails.setTModelInstanceInfo(info);
    }

    public Description[] getDescription() {
        return this.description;
    }

    public void setDescription(Description[] description) {
        this.description = description;
    }

    public Description getDescription(int i) {
        return this.description[i];
    }

    public void setDescription(int i, Description value) {
        this.description[i] = value;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(AccessPoint accessPoint) {
        this.accessPoint = accessPoint;
    }

    public HostingRedirector getHostingRedirector() {
        return this.hostingRedirector;
    }

    public void setHostingRedirector(HostingRedirector hostingRedirector) {
        this.hostingRedirector = hostingRedirector;
    }

    public TModelInstanceDetails getTModelInstanceDetails() {
        return this.tModelInstanceDetails;
    }

    public void setTModelInstanceDetails(TModelInstanceDetails tModelInstanceDetails) {
        this.tModelInstanceDetails = tModelInstanceDetails;
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(ServiceKey serviceKey) {
        this.serviceKey = serviceKey;
    }

    public BindingKey getBindingKey() {
        return this.bindingKey;
    }

    public void setBindingKey(BindingKey bindingKey) {
        this.bindingKey = bindingKey;
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof BindingTemplate)) {
            return false;
        }
        BindingTemplate other = (BindingTemplate)obj;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == obj;
        }
        this.__equalsCalc = obj;
        boolean _equals = (this.description == null && other.getDescription() == null || this.description != null && Arrays.equals(this.description, other.getDescription())) && (this.accessPoint == null && other.getAccessPoint() == null || this.accessPoint != null && this.accessPoint.equals(other.getAccessPoint())) && (this.hostingRedirector == null && other.getHostingRedirector() == null || this.hostingRedirector != null && this.hostingRedirector.equals(other.getHostingRedirector())) && (this.tModelInstanceDetails == null && other.getTModelInstanceDetails() == null || this.tModelInstanceDetails != null && this.tModelInstanceDetails.equals(other.getTModelInstanceDetails())) && (this.serviceKey == null && other.getServiceKey() == null || this.serviceKey != null && this.serviceKey.equals(other.getServiceKey())) && (this.bindingKey == null && other.getBindingKey() == null || this.bindingKey != null && this.bindingKey.equals(other.getBindingKey()));
        this.__equalsCalc = null;
        return _equals;
    }

    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getDescription() != null) {
            for (int i = 0; i < Array.getLength(this.getDescription()); ++i) {
                Object obj = Array.get(this.getDescription(), i);
                if (obj == null || obj.getClass().isArray()) continue;
                _hashCode += obj.hashCode();
            }
        }
        if (this.getAccessPoint() != null) {
            _hashCode += this.getAccessPoint().hashCode();
        }
        if (this.getHostingRedirector() != null) {
            _hashCode += this.getHostingRedirector().hashCode();
        }
        if (this.getTModelInstanceDetails() != null) {
            _hashCode += this.getTModelInstanceDetails().hashCode();
        }
        if (this.getServiceKey() != null) {
            _hashCode += this.getServiceKey().hashCode();
        }
        if (this.getBindingKey() != null) {
            _hashCode += this.getBindingKey().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    public static TypeDesc getTypeDesc() {
        return typeDesc;
    }

    public static Serializer getSerializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanSerializer(_javaType, _xmlType, typeDesc);
    }

    public static Deserializer getDeserializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanDeserializer(_javaType, _xmlType, typeDesc);
    }

    public void saveToXML(Element parent) {
        this.baseElement = parent.getOwnerDocument().createElement("bindingTemplate");
        if (this.bindingKey != null) {
            this.baseElement.setAttribute("bindingKey", this.bindingKey.getValue());
        }
        if (this.serviceKey != null) {
            this.baseElement.setAttribute("serviceKey", this.serviceKey.getValue());
        }
        if (this.description != null && this.description.length > 0) {
            for (int i = 0; i < this.description.length; ++i) {
                if (this.description[i] == null) continue;
                this.description[i].saveToXML(this.baseElement);
            }
        }
        if (this.accessPoint != null) {
            this.accessPoint.saveToXML(this.baseElement);
        }
        if (this.hostingRedirector != null) {
            this.hostingRedirector.saveToXML(this.baseElement);
        }
        if (this.tModelInstanceDetails != null) {
            this.tModelInstanceDetails.saveToXML(this.baseElement);
        }
        parent.appendChild(this.baseElement);
    }

    static {
        dummyHostingRedirector = new HostingRedirector();
        dummyHostingRedirector.setBindingKey(new BindingKey(""));
        typeDesc = new TypeDesc(BindingTemplate.class);
        typeDesc.setXmlType(new QName("urn:uddi-org:api_v2", "bindingTemplate"));
        AttributeDesc attrField = new AttributeDesc();
        attrField.setFieldName("serviceKey");
        attrField.setXmlName(new QName("", "serviceKey"));
        attrField.setXmlType(new QName("urn:uddi-org:api_v2", "serviceKey"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        attrField = new AttributeDesc();
        attrField.setFieldName("bindingKey");
        attrField.setXmlName(new QName("", "bindingKey"));
        attrField.setXmlType(new QName("urn:uddi-org:api_v2", "bindingKey"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("description");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "description"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "description"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("accessPoint");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "accessPoint"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "accessPoint"));
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("hostingRedirector");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "hostingRedirector"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "hostingRedirector"));
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("TModelInstanceDetails");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "tModelInstanceDetails"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "tModelInstanceDetails"));
        typeDesc.addFieldDesc((FieldDesc)elemField);
    }
}

